'use strict';

withdrawals.controllers.module('details-modal', [gx.source + '/libs/info_messages'], function () {
	return {
		vue: true,
		name: 'gx-details-modal',
		template: '#details-modal',
		parent: 'gx-withdrawals-overview',
		data: function data() {
			return {
				lang: {
					title: jse.core.lang.translate('details_modal_title', 'withdrawals'),
					close: jse.core.lang.translate('details_modal_close', 'withdrawals'),
					updateOrderId: jse.core.lang.translate('details_modal_update_order_id', 'withdrawals'),
					labels: {
						"customerDetails": jse.core.lang.translate('details_modal_label_customer_details', 'withdrawals'),
						"orderDetails": jse.core.lang.translate('details_modal_label_order_details', 'withdrawals'),
						"withdrawal": jse.core.lang.translate('details_modal_label_withdrawal', 'withdrawals'),
						"address": jse.core.lang.translate('details_modal_label_address', 'withdrawals'),
						"email": jse.core.lang.translate('details_modal_label_email', 'withdrawals'),
						"orderDate": jse.core.lang.translate('details_modal_label_order_date', 'withdrawals'),
						"deliveryDate": jse.core.lang.translate('details_modal_label_order_delivery_date', 'withdrawals'),
						"withdrawalDate": jse.core.lang.translate('details_modal_label_withdrawal_date', 'withdrawals'),
						"createdOn": jse.core.lang.translate('details_modal_label_withdrawal_created_on', 'withdrawals'),
						"createdByAdmin": jse.core.lang.translate('details_modal_label_withdrawal_created_by_admin', 'withdrawals'),
						"createdByCustomer": jse.core.lang.translate('details_modal_label_withdrawal_created_by_customer', 'withdrawals'),
						"orderId": jse.core.lang.translate('details_modal_label_withdrawal_order_id', 'withdrawals')
					},
					male: jse.core.lang.translate('details_modal_label_male_customer', 'withdrawals'),
					female: jse.core.lang.translate('details_modal_label_female_customer', 'withdrawals'),
					confirm: jse.core.lang.translate('save', 'buttons')
				},
				withdrawal: undefined,
				orderId: 0,
				orderIdOk: true
			};
		},
		props: {
			withdrawalId: {
				type: Number
			}
		},
		watch: {
			withdrawalId: function withdrawalId(newVal) {
				if (newVal !== undefined) {
					var vm = this;
					jse.libs.xhr.post({
						url: './admin.php?do=Withdrawals/GetWithdrawal',
						data: { id: this.withdrawalId }
					}).done(function (response) {
						vm.withdrawal = response.withdrawal;
						vm.orderId = response.withdrawal.order.id;
						$('.details-modal.modal').modal('show');
					}).fail(function (response) {
						console.error('Could not load withdrawal details.', response);
						jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_load_withdrawal_details', 'withdrawals'));
					});
				}
			}
		},
		methods: {
			checkOrderId: function checkOrderId() {
				if (this.orderId === '') {
					this.orderIdOk = true;
					return;
				}
				this.orderIdOk = Number.isInteger(parseInt(this.orderId)) && parseInt(this.orderId) > 0;
				this.orderId = isNaN(parseInt(this.orderId)) ? '' : parseInt(this.orderId);
			},
			confirm: function confirm() {
				var _this = this;

				if (this.orderId !== '' && this.orderIdOk && this.orderId !== this.withdrawal.order.id) {
					jse.libs.xhr.post({
						url: './admin.php?do=Withdrawals/ChangeOrderId',
						data: { id: this.withdrawalId, orderId: parseInt(this.orderId) }
					}).done(function (response) {
						_this.$emit('reload-overview');
					}).fail(function (response) {
						console.error('Could not update order ID.', response);
						jse.libs.info_messages.addError(jse.core.lang.translate('error_could_not_update_order_id', 'withdrawals'));
					});
				}
				$('.details-modal.modal').modal('hide');
			}
		},
		init: function init(done) {
			return done();
		}
	};
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
